#include <pvm3.h>
#include "pvmstuff.h"
#include "inet.h"
#include <math.h>
#include <stdio.h>
#include "model.h"
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include "pvm_error.h"
#include "pvm_debug.h"
#include <string.h>
#include "krige_client.h"


#ifdef FULL_DEBUG
#define PVM_DEBUG 1 
#endif
// todo: replace all TEST_NULL functions
//       replace debug functions
#ifdef PVM_DEBUG
 FILE *fp;
#endif

#define TEST_NULL(memory,msg)  \
 if (memory==NULL) { \
   syslog(LOG_WARNING,msg); \
   closelog(); \
   status=pvm_exit(); \
   pvm_error(PVM_EXIT,status,"<pvm_exit> failed!\n"); \
   exit(EXIT_FAILURE); \
 }
double (*f)(double);
// different models require different functions
double (*model_function)(double,double,double,double);

double gaussian(double h, double p1, double p2, double p3) {
  if (h==0.0) return 0.0;
  else return (p1 + p2 * (1 - exp(-pow(h,2.0)/pow(p3,2.0))));
}

double linear(double h, double p1, double p2, double p3) {
  if (h==0.0) return 0.0;
  else return (p1+p2*h);  
}

double exponential(double h, double p1, double p2, double p3) {
  if (h==0.0) return 0.0;
  else return (p1+p2*(1-exp(-h/p3)));
}

double spherical(double h, double p1, double p2, double p3) {
  if (h==0.0) return 0.0;
  else if (h<=p3) return (p1+p2*(3.0/2.0 * h/p3 - 0.5*pow(h/p3,3.0)));
  else return (p1+p2);
}



int main(void) {
  int     ptid, cc, i,j,k,l,s;

  size_msg param_size;
  static_msg param;
  double *lon, *lat, *z, *xgwork, *ygwork, *lon0, *lat0;
  int *dog, *do0, *inddo, *indsnb, *indsnw, *indsrt, *ipiv, ldcov,ldc0,ldfwrk,ldf0wk,nkwork,*snbbit,usesbbt,ierr,ldlmbd, n0;
  double *covmat,*c0vec,*fwork,*f0work,*dist,*kwork,*rhswork, *mu,*lambda, cov0;
  double covpar[3];
  double *dst, d;
  message parameter;
  double *result_buffer;
  tile_result res;
  tile_job todo;
  int status;
  pid_t client_pid;
#ifdef PVM_DEBUG
  int tmp,line,col;
#endif
  

  client_pid=getpid();
  __DEBUG2("Starting pvm_client with PID %i!\n", client_pid);
  // sleep(5);
  // get master tid
  ptid = pvm_parent(); 
  pvm_error(PVM_PARENT,ptid,"<pvm_parent> failed!\n");

  // initial part
  // receive parameter settings
  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkint((int*)&(param_size),sizeof(size_msg)/sizeof(int),1); 
  pvm_error(PVM_UPKINT,status,"<pvm_upkint> failed!\n");

  __DEBUG2("Parameter: n (%i) \n",param_size.n);
  __DEBUG2("Parameter: nx (%i) \n",param_size.nx);
  __DEBUG2("Parameter: ny (%i) \n",param_size.ny);
  __DEBUG2("Parameter: nt (%i) \n",param_size.nt);
  __DEBUG2("Parameter: ntx (%i) \n",param_size.ntx);
  __DEBUG2("Parameter: nty (%i) \n",param_size.nty);
  __DEBUG2("Parameter: ntrend (%i) \n",param_size.ntrend);

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkint((int*)&(param.i),sizeof(static_msg_i)/sizeof(int),1); 
  pvm_error(PVM_UPKINT,status,"<pvm_upkint> failed!\n");

  __DEBUG2("Parameter: covtype (%i) \n",param.i.covtype);
  __DEBUG2("Parameter: mode (%i) \n",param.i.mode);
  __DEBUG2("Parameter: trend (%i) \n",param.i.trend);
  __DEBUG2("Parameter: nsearch (%i) \n",param.i.nsearch);
  __DEBUG2("Parameter: nsmin (%i) \n",param.i.nsmin);
  __DEBUG2("Parameter: nsmax (%i) \n",param.i.nsmax);

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)&(param.d),sizeof(static_msg_d)/sizeof(double),1); 
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG2("Parameter: rsearch (%f) \n",param.d.rsearch);
  __DEBUG2("Parameter: nugget (%f) \n",param.d.nugget);
  __DEBUG2("Parameter: sill (%f) \n",param.d.sill);
  __DEBUG2("Parameter: range (%f) \n",param.d.range);


  __DEBUG1("choose covariance function!\n");

  // set function point to required function
  switch (param.i.covtype) {
  case GAUSSIAN_MODEL: 
    model_function=gaussian;
    break;
  case EXPONENTIAL_MODEL:
    model_function=exponential;
    break;
  case LINEAR_MODEL:
    model_function=linear;
    break;
  case SPHERICAL_MODEL:
    model_function=spherical;
    break;
  default: 
    syslog(LOG_WARNING,"Wrong model specified (%d)",param.i.covtype);
    closelog();
    status=pvm_exit();
    pvm_error(PVM_EXIT,status,"<pvm_exit> failed!\n");
    exit(EXIT_FAILURE);
  }

  // allocate memory 
  lon=(double*)malloc(param_size.n*sizeof(double));
  TEST_NULL(lon,"Memory allocation problem (lon)");
  lat=(double*)malloc(param_size.n*sizeof(double));
  TEST_NULL(lat,"Memory allocation problem (lat)");
  z=(double*)malloc(param_size.n*sizeof(double));
  TEST_NULL(z,"Memory allocation problem (z)");

  xgwork=(double*)malloc(param_size.nx*param_size.ny*sizeof(double));
  TEST_NULL(xgwork,"Memory allocation problem (xgwork)");
  ygwork=(double*)malloc(param_size.nx*param_size.ny*sizeof(double));
  TEST_NULL(ygwork,"Memory allocation problem (ygwork)");
  dog=(int*)malloc(param_size.nx*param_size.ny*sizeof(int));
  TEST_NULL(dog,"Memory allocation problem (dog)");

  __DEBUG1("Memory allocated!\n");

  // receive data
  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)lon,param_size.n,1); 
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("got lon\n");

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)lat ,param_size.n ,1); 
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("got lat\n");

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)z ,param_size.n ,1); 
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("got z\n");

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)xgwork,param_size.nx*param_size.ny,1); 
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("got xgwork\n");

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)ygwork,param_size.nx*param_size.ny,1); 
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("got ygwork\n");

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkint((int*)dog,param_size.nx*param_size.ny,1);
  pvm_error(PVM_UPKINT,status,"<pvm_upkint> failed!\n");

  __DEBUG1("got dog\n");


  covpar[0]=param.d.nugget;
  covpar[1]=param.d.sill;
  covpar[2]=param.d.range;

  // calculate cov matrix:
  covmat=(double*)malloc((param_size.n)*(param_size.n)*sizeof(double));
  TEST_NULL(covmat,"Memory allocation problem (covmat)");
  ldcov=param_size.n;



  for(i=0;i<param_size.n;i++)
      for(j=0;j<param_size.n;j++){
	  d=sqrt((lon[i]-lon[j])*(lon[i]-lon[j])+
		 (lat[i]-lat[j])*(lat[i]-lat[j]));
	  covmat[j*param_size.n+i]=
	      F77_CALL(covfn)(&param.i.covtype,
			      covpar, &d);
	  covmat[i*param_size.n+j]=covmat[j*param_size.n+i];
	  
      }

  // got initial data - wait for jobs

  while (1) {
      cc = pvm_recv(ptid,MSGTAG_SENDJOB);
      pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
      status=pvm_upkint((int*)&todo,sizeof(tile_job)/sizeof(int),1);	    
      pvm_error(PVM_UPKINT,status,"<pvm_upkint> failed!\n");

      __SET_DEBUG_FILE("/tmp/pvm_client_todo.txt");
      __DEBUG2("Got job id %d\n",todo.id);
      __DEBUG2("Number of points to compute: %d\n",(int)todo.nr_points);
      
      res.id=(double)todo.id; // we return the same id nr as we received
      if ((int)todo.nr_points>0) {
	  res.nr_points=(double)todo.nr_points;
      res.z=(double*)malloc((param_size.itx)*(param_size.ity)*sizeof(double));
      TEST_NULL(res.z,"Memory allocation problem (res.z)");
      res.var=(double*)malloc((param_size.itx)*(param_size.ity)*sizeof(double));
      TEST_NULL(res.var,"Memory allocation problem (res.var)");
      lon0=(double*)malloc((param_size.itx)*(param_size.ity)*sizeof(double));
      TEST_NULL(lon0,"Memory allocation problem (lon0)");
      lat0=(double*)malloc((param_size.itx)*(param_size.ity)*sizeof(double));
      TEST_NULL(lat0,"Memory allocation problem (lat0)");
      do0=(int*)malloc((param_size.itx)*(param_size.ity)*sizeof(int));
      TEST_NULL(do0,"Memory allocation problem (do0)");
      
      inddo=(int*)malloc((param_size.itx)*(param_size.ity)*sizeof(int));
      TEST_NULL(inddo,"Memory allocation problem (inddo)");
      n0=(int)todo.nr_points;
      c0vec=(double*)malloc((param_size.n)*(int)todo.nr_points*sizeof(double));
      TEST_NULL(c0vec,"Memory allocation problem (c0vec)");
      ldc0=param_size.n;
      fwork=(double*)malloc((param_size.n)*(param_size.ntrend)*sizeof(double));
      TEST_NULL(fwork,"Memory allocation problem (fwork)");
      ldfwrk=param_size.n;
      f0work=(double*)malloc((param_size.n)*(int)todo.nr_points*sizeof(double));
      TEST_NULL(f0work,"Memory allocation problem (f0work)");
      ldf0wk=param_size.n;
      dist=(double*)malloc((param_size.n)*sizeof(double));
      TEST_NULL(dist,"Memory allocation problem (dist)");
      indsnb=(int*)malloc((param_size.n)*sizeof(int));
      TEST_NULL(indsnb,"Memory allocation problem (indsnb)");
      indsnw=(int*)malloc((param_size.n)*sizeof(int));
      TEST_NULL(indsnw,"Memory allocation problem (indsnw)");
      indsrt=(int*)malloc((param_size.n)*sizeof(int));
      TEST_NULL(indsrt,"Memory allocation problem (indsrt)");
      kwork=(double*)malloc((param_size.n+param_size.ntrend)*(param_size.n+param_size.ntrend)*sizeof(double));
      TEST_NULL(kwork,"Memory allocation problem (kwork)");
      nkwork=param_size.n+param_size.ntrend;
      rhswork=(double*)malloc((param_size.n+param_size.ntrend)*(int)todo.nr_points*sizeof(double));
      TEST_NULL(rhswork,"Memory allocation problem (rhswork)");
      ipiv=(int*)malloc((param_size.n+param_size.ntrend)*(int)todo.nr_points*sizeof(int));
      TEST_NULL(ipiv,"Memory allocation problem (ipiv)");
      mu=(double*)malloc((param_size.ntrend)*(int)todo.nr_points*sizeof(double)); 
      TEST_NULL(mu,"Memory allocation problem (mu)");
      lambda=(double*)malloc((param_size.n)*(int)todo.nr_points*sizeof(double)); 
      TEST_NULL(lambda,"Memory allocation problem (lambda)");
      ldlmbd=param_size.n;
      
      snbbit=(int*)malloc((param_size.n)*sizeof(int)); 
      TEST_NULL(snbbit,"Memory allocation problem (snbbit)");
      for(k=0;k<param_size.n;k++){
	  snbbit[k]=0;
      }
      usesbbt=0;

      __SET_DEBUG_FILE("/tmp/pvm_client_debug.txt");
      __DEBUG2("JOBNR: %d\n",todo.id);
      __DEBUG2("i lower: %d\n",todo.i_lower);
      __DEBUG2("i upper: %d\n",todo.i_upper);
      __DEBUG2("i lower: %d\n",todo.j_lower);
      __DEBUG2("i upper: %d\n",todo.j_upper);
      // extract lon0/lat0 from xgwork/ygwork
      // extract do0 from dog
      s=0;
      for(k=todo.i_lower;k<=todo.i_upper;k++)
	  for(l=todo.j_lower;l<=todo.j_upper;l++){
	      lon0[s]=xgwork[l*(param_size.nx)+k];
	      lat0[s]=ygwork[l*(param_size.nx)+k];
	      do0[s]=dog[l*(param_size.nx)+k];
	      s++;
	  }
		
	

      // call fortran function
      F77_CALL(krige)(lon0,
		      lat0,
		      do0,
		      inddo,
		      &n0,
		      lon,
		      lat,
		      z,
		      &param_size.n,
		      &param.i.covtype,
		      covpar,
		      covmat,
		      &ldcov,
		      c0vec,
		      &ldc0,
		      &cov0,
		      &param.i.trend,
		      &param_size.ntrend,
		      &param.d.rsearch,
		      &param.i.nsearch,
		      &param.i.nsmin,
		      &param.i.nsmax,
		      fwork,
		      &ldfwrk,
		      f0work,
		      &ldf0wk,
		      dist,
		      indsnb,
		      indsnw,
		      indsrt,
		      kwork,
		      &nkwork,
		      rhswork,
		      ipiv,
		      &param.i.mode,
		      mu,
		      res.z,
		      lambda,
		      &ldlmbd,
		      res.var,
		      snbbit,
		      &usesbbt,
		      &ierr);
     
      __SET_DEBUG_FILE("/tmp/pvm_client.txt");
      __DEBUG1("Send results back...\n");

      // send result
      result_buffer=(double*)malloc((2*((param_size.itx)*(param_size.ity))+2)*sizeof(double));
      memset(result_buffer,0,sizeof(double)*(2*((param_size.itx)*(param_size.ity))+2));
      result_buffer[0]=res.nr_points;
      result_buffer[1]=res.id;
      for(i=0;i<(int)res.nr_points;i++){
	      result_buffer[2+i]=res.z[i];
	      result_buffer[2+(int)res.nr_points+i]=res.var[i];
      }


      status=pvm_initsend(PvmDataDefault);
      pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
      status=pvm_pkdouble((double*)result_buffer,2*((param_size.itx)*(param_size.ity))+2,1);
      pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed!\n");
      status=pvm_send(ptid, MSGTAG_KRIGE);
      pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

      free(result_buffer);
      free(snbbit);
      free(lambda);
      free(mu);
      free(ipiv);
      free(rhswork);
      free(kwork);
      free(indsrt);
      free(indsnw);
      free(indsnb);
      free(dist);
      free(f0work);
      free(fwork);
      free(c0vec);
      free(inddo);
      free(do0);
      free(lat0);
      free(lon0);
      free(res.var);
      free(res.z);
      
      __DEBUG1("Results were send...\n");
    } // end if (todo.nr_points>0)
  } // end while 
  free(covmat);
  free(dog);
  free(ygwork);
  free(xgwork);
  free(z);
  free(lat);
  free(lon);

  // prg will never reach these lines - 
  // because master kills clients
  status=pvm_exit(); 
  pvm_error(PVM_EXIT,status,"<pvm_exit> failed!\n");

  return(EXIT_SUCCESS);
}

