#include <stdlib.h>
#include <stdio.h>
#include <syslog.h>
#include <errno.h>
#include "../pvm_error.h"

void pvm_error(int operation,int status,char *txt) {
  int quit=0; //true


  switch (operation) {
  case PVM_SPAWN:
    /*

      PvmBadParam
              giving an invalid argument value.

      PvmNoHost
              Specified host is not in the virtual machine.

      PvmNoFile
              Specified  executable  cannot be found. The default
              location PVM looks  in  is  ~/pvm3/bin/ARCH,  where
              ARCH is a PVM architecture name.

       PvmNoMem
              Malloc failed. Not enough memory on host.

       PvmSysErr
              pvmd not responding.

       PvmOutOfRes
              out of resources.


     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_NOTIFY:
    /*
     PvmSysErr
              pvmd not responding.

     PvmBadParam
              giving an invalid argument value.


     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_CONFIG:
    /*
       PvmSysErr
              pvmd not responding.

     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_PKINT:
  case PVM_PKDOUBLE:
    /*
      PvmNoMem
              Malloc has failed. Message buffer size has exceeded
              the available memory on this host.

       PvmNoBuf
              There  is  no active send buffer to pack into.  Try
              calling pvm_initsend before packing message.

       PvmOverflow
              Attempt to pack a value too large.  E.g. packing an
              8-byte  long  with  XDR encoding if the value won't
              fit into 4 bytes.
     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_KILL: 
    /*
       PvmBadParam
              giving an invalid tid value.

       PvmSysErr
              pvmd not responding.
     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_INITSEND: 
    /*
      PvmBadParam
              giving an invalid tid or a msgtag.

       PvmSysErr
              pvmd not responding.

       PvmNoBuf
              no active send buffer.  Try  pvm_initsend()  before
              send.

     */
    // if ((status==PvmBadParam) || (status==PvmNoMem)) {
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_RECV:
    /*
       PvmBadParam
              giving an invalid tid value, or msgtag < -1.

       PvmSysErr
              pvmd not responding.

     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_UPKINT:
  case PVM_UPKDOUBLE:
    /*
     PvmNoBuf
              There is no active receive buffer to unpack.

     PvmNoData
              Reading beyond the end of the receive buffer.  Most
              likely  cause  is  trying to unpack more items than
	      were originally packed into the buffer.

     PvmBadMsg
              The received message  can  not  be  decoded.   Most
              likely  because the hosts are heterogeneous and the
              user specified an incompatible encoding.  Try  set
	      ting    the   encoding   to   PvmDataDefault   (see
              pvm_mkbuf).
     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_SEND:
    /*
      PvmBadParam
              giving an invalid tid or a msgtag.

       PvmSysErr
              pvmd not responding.

       PvmNoBuf
              no active send buffer.  Try  pvm_initsend()  before
              send.

     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_BUFINFO:
    /*
      PvmNoSuchBuf
              specified buffer does not exist.

      PvmBadParam
              invalid argument

     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_EXIT:
    /*
      PvmSysErr
              pvmd not responding

     */
    if (status<0) {
      quit=-1;
    }
    break;
  case PVM_PARENT:
    /*
       PvmNoParent
              The calling process was not created with pvm_spawn.

       PvmSysErr
              Can't contact local pvmd.

     */
    if ((status==PvmNoParent) || (status==PvmSysErr)) {
      quit=-1;
    }
    break;
  default:
    syslog(LOG_WARNING,"pvm_error: unknown operation !(%d)",operation);
    pvm_exit();
    exit(EXIT_FAILURE);
  }
  if (quit==-1) {
    syslog(LOG_WARNING,"%s!",txt);
    pvm_exit();
    exit(EXIT_FAILURE);
  }
}
