#ifndef INET
#define INET 1


#include <errno.h>

#define FAILURE        -1
#define SUCCESS        !FAILURE
//#define SERV_TCP_PORT  50050
#define PVMKRIGE_PORT_NAME "pvm-krige"
//#define BUFFERSIZE     8

// socket descriptor - file descriptor

// in-socket: (receive socket)
// set to 0 if program was started by inetd
// else >0
int fd_in;
// out-socket: (send socket)
// set to 1 if program was started by inetd
// else > 1 
int fd_out;

// to be able to start pvm_server with inetd uncomment this define
// #define START_WITH_INETD

// message structure is used to send the matrix dimensions
typedef struct message_int{
#if defined(__osf__)
    int plen;
    int slen;
#else
  long plen;
  long slen;
#endif
  int model;
} message_int;
typedef struct message_double{
  double param0;
  double param1;
  double param2;
  double dummy; 
} message_double;

typedef struct message{
    message_int int_message;
    message_double double_message;
} message;


typedef struct size_msg{
    int n;
    int nx;
    int ny;
    int nt;
    int ntx;
    int nty;
    int itx;
    int ity;
    int nxper;
    int nyper;
    int ntrend;
} size_msg;

typedef struct static_msg_i {
    int covtype;
    int mode;
    int trend;
    int nsearch;
    int nsmin;
    int nsmax;
    int nxper;
    int nyper;
} static_msg_i;

typedef struct static_msg_d {
    double rsearch;
    double nugget;
    double sill;
    double range;
} static_msg_d;

typedef struct static_msg{
    static_msg_i i;
    static_msg_d d;
} static_msg;

/*
typedef struct message
{
#if defined(__osf__)
    int plen;
    int slen;
#else
  long plen;
  long slen;
#endif
  int model;
  double param0;
  double param1;
  double param2;
  double dummy; 
  // without this dummy variable the data is not transmitted correctly
  // i think a problem of pvm and packing/unpacking
} message;
*/

typedef struct syncmsg 
{
  int ok;
} syncmsg;

/*    
 function writen and readn return the nr of written or received bytes in case of success
 otherwise FAILURE is send
*/ 
int writen(register int fd,register char *ptr,register int nbytes);
int readn(register int fd,register char *ptr,register int nbytes);

/*    
 function writen and readn return the nr of written or received bytes in case of success
 otherwise FAILURE is send
*/  
//int large_get(register int fd,register double **ptr);
int write_socket(register int fd,register char *ptr,register int bytes);
int read_socket(register int fd,register char *ptr,register int bytes);

#endif
