#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "inet.h"
#include "socket.h"
#include "model.h" 
#include "pvm_debug.h" 

#define TEST_FAILURE(res,msg) \
  if (res==FAILURE) { \
    perror(msg); \
    close(sockfd); \
    goto finish; \
  }

void pvmkrige(pointx,pointy,pointz,plen,sx,sy,slen,zhat,sigma2hat,model,
	  parameter_,gmatrix_inv,gvector,dst,lambda_hat,sdo)
double *pointx,*pointy,*pointz;
long *plen;
double *sx,*sy;
long *slen;
double *zhat,*sigma2hat;
char **model;
double *parameter_;
double *gmatrix_inv;
double *gvector;
double *dst;
double *lambda_hat;
double *sdo;
{
  int sockfd,retval;
  struct servent *sp;
  message parameter;
  syncmsg okmsg; 
  struct sockaddr_in addr;
  
  // hello msg
  okmsg.ok=1;

  // ------------------------------------------------------------
  // send parameter
  parameter.int_message.plen=*plen;
  parameter.int_message.slen=*slen;

  // set default 
  parameter.int_message.model=-1;

  if (strcmp("gaussian",*model)==0)
   parameter.int_message.model=GAUSSIAN_MODEL;
  if (strcmp("exponential",*model)==0)
   parameter.int_message.model=EXPONENTIAL_MODEL;
  if (strcmp("linear",*model)==0)
   parameter.int_message.model=LINEAR_MODEL;
  if (strcmp("spherical",*model)==0)
   parameter.int_message.model=SPHERICAL_MODEL;
  
  parameter.double_message.param0=parameter_[0];
  parameter.double_message.param1=parameter_[1];
  parameter.double_message.param2=parameter_[2];

  __DEBUG7("Original: \nPlen: %i\nSlen: %i\nParam0: %f\nParam1: %f\nParam2: %f\nModel: %s\n",
	   *plen,*slen,parameter_[0],parameter_[1],parameter_[2],*model);

  // ------------------------------------------------------------
   
  // determine port to use
  sp=getservbyname(PVMKRIGE_PORT_NAME,"tcp");

  if (sp==NULL) {
    perror("Unable to determine port number!\n");
    //exit(EXIT_FAILURE);
    goto finish;    
  }

  // address of the server we want to connect to
  // here the server resides at the same host as the client
  bzero((char*)&addr,sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_addr.s_addr=htonl(INADDR_ANY);
  addr.sin_port=htons(sp->s_port);


  // create socket
  if ((sockfd=socket(AF_INET,SOCK_STREAM,0))<0)
  {
    perror("Can't open stream socket\n");
    //exit(EXIT_FAILURE);
    goto finish;
  }
 
  if (connect(sockfd,(struct sockaddr *) &addr,sizeof(addr))<0)
  {
    perror("Can't connect to serv.\n");
    printf("Errno: %d\n",errno);
    close(sockfd);
    //exit(EXIT_FAILURE);
    goto finish;
  }

  // handshake with server
  retval=writen(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"Can not send ok msg to server! - handshake failed!\n");


  // wait for response from server
  retval=readn(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"No response from server! - handshake failed!\n");
 

  // handshake finished - do some work!


  // ------------------------------------------------------------

  // send client information about the size of data
  __DEBUG1("Send info about datasize\n");

  retval=writen(sockfd,(char*)&parameter,sizeof(message));
  TEST_FAILURE(retval,"Could not send data about datasize!\n");
 
  // server has received dimension data
  __DEBUG1("Server got parameter settings\n");

  retval=readn(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"No response from server after he received dimension data!\n");

  // send data
  send_data(sockfd,pointx,*plen*sizeof(double),"pointx","Could not transmit data correctly",
	    "No response from server after he received pointx!");
  send_data(sockfd,pointy,*plen*sizeof(double),"pointy","Could not transmit data correctly",
	    "No response from server after he received pointy!");
  send_data(sockfd,pointz,*plen*sizeof(double),"pointz","Could not transmit data correctly",
	    "No response from server after he received pointz!");
  send_data(sockfd,sx,*slen*sizeof(double),"sx","Could not transmit data correctly",
	    "No response from server after he received sx!");
  send_data(sockfd,sy,*slen*sizeof(double),"sy","Could not transmit data correctly",
	    "No response from server after he received sy!");
  send_data(sockfd,zhat,*slen*sizeof(double),"zhat","Could not transmit data correctly",
	    "No response from server after he received zhat!");
  send_data(sockfd,sigma2hat,*slen*sizeof(double),"sigma2hat","Could not transmit data correctly",
	    "No response from server after he received sigma2hat!");
  send_data(sockfd,gmatrix_inv,(*plen+1)*(*plen+1)*sizeof(double),"gvector","Could not transmit data correctly",
	    "No response from server after he received gmatrix_inv");
  send_data(sockfd,gvector,(*plen+1)*sizeof(double),"gvector","Could not transmit data correctly",
	    "No response from server after he received gvector");
  send_data(sockfd,dst,*plen*sizeof(double),"dst","Could not transmit data correctly",
	    "No response from server after he received dst");
  send_data(sockfd,lambda_hat,(*plen+1)*sizeof(double),"lambda_hat","Could not transmit data correctly",
	    "No response from server after he received lambda_hat!");
  send_data(sockfd,sdo,*slen*sizeof(double),"sdo","Could not transmit data correctly",
	    "No response from server after he received sdo!");

  // wait for results

  retval=readn(sockfd,(char*)&zhat[0],*slen*sizeof(double));
  TEST_FAILURE(retval,"zhat was not received properly!\n");

  __DEBUG1("Got result: zhat\n");

  // send ack to server
  retval=writen(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"Can not send ok msg to server!\n");

  // wait for sigma2hat
  retval=readn(sockfd,(char*)&sigma2hat[0],*slen*sizeof(double));
  TEST_FAILURE(retval,"sigma2hat was not received properly!\n");

  // ------------------------------------------------------------------

  // send final ack to server
  retval=writen(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"Can not send final ok msg to server!\n");

  close(sockfd);       
  finish:
}
