#include "socket.h"

#define TEST_FAILURE(res,msg) \
  if (res==FAILURE) { \
    perror(msg); \
    close(sockfd); \
    return -1; \
  }

// len in bytes 
int send_data(int sockfd,void *buffer,int len,char *msg,char *err,char *err2)
{
  int retval;
  syncmsg okmsg;
  okmsg.ok=1;
 
  __DEBUG2("Send %s\n",msg);

  //retval=large_send(sockfd,matrix,data_size);
  retval=writen(sockfd,(char*)buffer,len);
  TEST_FAILURE(retval,err)

  __DEBUG2("Wait for ok for %s\n",msg);

  retval=readn(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,err2)

  return 0;
}

/*
static int large_send(int fd,double *ptr,int bytes)
{
  int nr,retval,got;
  char buffer[2];
  
  nr=bytes / BUFFERSIZE;
  retval=write_socket(fd,(char*)&bytes,sizeof(int)); // send size
  got=read_socket(fd,(char*)&buffer[0],2); // wait for ok
  retval=0;
  while (nr>0)
  {
	  retval+=write_socket(fd,ptr,BUFFERSIZE);
	  got=read_socket(fd,(char*)&buffer[0],2);
	  nr--;
	  ptr=ptr+(BUFFERSIZE/sizeof(double));
  }
  if ((bytes%BUFFERSIZE)>0)
  {
   	  retval+=write_socket(fd,ptr,bytes % BUFFERSIZE);
	  got=read_socket(fd,(char*)&buffer[0],2);
  }     
  return retval;
}
*/

int recv_data(int sockfd, void *buffer, int len, char *msg, char *err, char *err2){
    int retval;
    syncmsg okmsg;
    okmsg.ok=1;    
    
    retval=readn(sockfd,buffer,len);
    TEST_FAILURE(retval,err);
    
    __DEBUG1(msg);
    
    // send ack to server
    retval=writen(sockfd,(char*)&okmsg,sizeof(syncmsg));
    TEST_FAILURE(retval,err2);
    
    
}
